<?LassoScript
	var: 'action' = (action_param: 'action');
	var: 'item' = (action_param: 'item');
	
	if: !(var_defined: 'nu_map');
		var: 'nu_map' = map;
		session_addvar: -name='ajax', 'nu_map';
	/if;
	
	if: ($action >> 'add');
		if: $nu_map->keys >> $item;
			$nu_map->(insert: $item = (integer: $nu_map->(find: $item)) + 1);
		else;
			$nu_map->(insert: $item = 1);
		/if;
	/if;

	if: ($action >> 'sub');
		if: $nu_map->keys >> $item;
			var: 'temp' = (integer: $nu_map->(find: $item)) - 1;
			if: $temp <= 0;
				$nu_map->(remove: $item);
			else;
				$nu_map->(insert: $item = $temp);
			/if;
		/if;
	/if;
	
	if: ($action >> 'rem');
		$nu_map->(remove: $item);
	/if;
	
?>
[ljax_target: 'page_frame', -notarget]
<p>Drag and Drop</p>

<p>This example shows how one or more objects can be dragged from one well to
the other.  Each time an object is dropped its position is stored (in a
session) so that when the page is reloade the objects all appear in the right
location.</p>

<p>This example could be extended to perform a database action when objects are
dragged or dropped.  For example, dropped objects could be added to a shopping
cart or membership in a group could be maintained by dragging users back and
forth.</p>

<hr />

<div style="background: blue; border-color: white; border-style: solid; border-width: 1px; width: 216px;">
	<div style="text-align: center; padding: 3px;">Items</div>
	<div style="background: white; height: 100%; padding: 3px;">
		<div>
			<span class="item" id="nu_item_one">T-Shirt</span>
			(<a id="nu_item_one_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_one" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>)
		</div>
		<div>
			<span class="item" id="nu_item_two">Coffee Mug</span>
			(<a id="nu_item_two_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_two" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>)
		</div>
		<div>
			<span class="item" id="nu_item_three">Mouse Pad</span>
			(<a id="nu_item_three_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_three" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>)
		</div>
	</div>
</div>

<hr />

<div id="nu_cart" style="background: blue; border-color: white; border-style: solid; border-width: 1px; width: 216px;">
	<div style="text-align: center; padding: 3px;">Cart</div>
[/ljax_target]
[ljax_target: (array: 'nu_content', 'page_frame'), -notarget]
	<div id="nu_content" style="background: white; height: 100%; padding: 3px;"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
		[if: $nu_map->size > 0]
			[if: (integer: $nu_map->(find: 'nu_one')) > 0]
				<div>
					<span class="cart" id="nu_cart_one">T-Shirt </span> 
					([integer: $nu_map->(find: 'nu_one')]
					<a id="nu_cart_one_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_one" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>
					<a id="nu_cart_one_sub" href="index.lasso?page=[var: 'page']&amp;action=sub&amp;item=nu_one" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">-</a>
					<a id="nu_cart_one_rem" href="index.lasso?page=[var: 'page']&amp;action=rem&amp;item=nu_one" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">x</a>)
				</div>
			[/if]
			[if: (integer: $nu_map->(find: 'nu_two')) > 0]
				<div>
					<span class="cart" id="nu_cart_two">Coffee Mug </span> 
					([integer: $nu_map->(find: 'nu_two')]
					<a id="nu_cart_two_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_two" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>
					<a id="nu_cart_two_sub" href="index.lasso?page=[var: 'page']&amp;action=sub&amp;item=nu_two" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">-</a>
					<a id="nu_cart_two_rem" href="index.lasso?page=[var: 'page']&amp;action=rem&amp;item=nu_two" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">x</a>)
				</div>
			[/if]
			[if: (integer: $nu_map->(find: 'nu_three')) > 0]
				<div>
					<span class="cart" id="nu_cart_three">Mouse Pad</span> 
					([integer: $nu_map->(find: 'nu_three')]
					<a id="nu_cart_three_add" href="index.lasso?page=[var: 'page']&amp;action=add&amp;item=nu_three" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">+</a>
					<a id="nu_cart_three_sub" href="index.lasso?page=[var: 'page']&amp;action=sub&amp;item=nu_three" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">-</a>
					<a id="nu_cart_three_rem" href="index.lasso?page=[var: 'page']&amp;action=rem&amp;item=nu_three" onclick="Lasso.includeTarget('nu_content', {args: this}); return false;">x</a>)
				</div>
			[/if]
		[else]
			Empty Cart. Add an item to the Cart
			by dragging it here.
		[/if]
	</div>
[/ljax_target]
[ljax_target: 'page_frame', -notarget]
</div>

<hr />

<div id="nu_trash" style="background: blue; border-color: white; border-style: solid; border-width: 1px; width: 216px;">
	<div style="text-align: center; padding: 3px;">Trash</div>
	<div style="background: white; height: 100%; padding: 3px;">
		Remove items from the cart by dragging them here.
	</div>
</div>

<p>The cart should be backwards compatible with older browsers.  The + - x buttons allows visitors
with browsers that don't support drag and drop to use the cart.  The buttons use AJAX to refresh
the cart without reloading the page, but also fallback on normal page reloads if JavaScript is
simply unavailable.</p>

<script type="text/javascript">
	nu_decorate();
</script>
[/ljax_target]